#!/usr/bin/python
__module_name__ = "Vuurdraak Bot"
__module_version__ = "1.0.2" 
__module_description__ = "Vuurdraak Bot made by Rene Christians"

import os
import re
import string
import time
import xchat

print ("\0036" + __module_name__ + " " + __module_version__ + " has been loaded succesfully")

#the globals go here
vuurdraak = {}
option = {}
xchatdir = xchat.get_info("xchatdir")
invalid = re.compile('[A-Z]', re.I)

#the functions go here
def load_vars():
    global vuurdraak
    try:
        vuurdraak[0] = round(time.time() )
        vuurdraak[1] = round(time.time() )
    
    except EnvironmentError:
        print ("\0034", "Error loading script")

    global option
    try:
        inifile = open(os.path.join(xchatdir,"vuurdraak.ini"), 'rU')
        option["anti_spam_speed"] = "2"
        line = inifile.readline() #The first line is a comment
        line = inifile.readline()
        if line == '\n' or line == '\r' or line == "" :
            line = inifile.readline()
        line.strip('\n')
        line.strip('\r')
        while line != "":
            if "[End of INI]" in line:
                print ("\00311" + "Vuurdraak Bot's vuurdraak.ini loaded successfully")
                print ("\00313" + "Anti spam speed is set to one command per " + str.strip(option["anti_spam_speed"]) + " seconds")
                inifile.close
                return xchat.EAT_NONE
            par1, par2 = re.split("=", line)
            option[par1] = str(par2)
            line = inifile.readline()
            if line == '\n' or line == '\r' or line == "":
                line = inifile.readline()
                if "[End of INI]" in line:
                    print ("\00311" + "Vuurdraak Bot's vuurdraak.ini loaded successfully")
                    print ("\00313" + "Anti spam speed is set to one command per " + str.strip(option["anti_spam_speed"]) + " seconds")
                    inifile.close
                    return xchat.EAT_NONE
            line.strip('\n')
            line.strip('\r')
        inifile.close

        print ("\00311" + "No [End of INI] found, but Vuurdraak Bot's vuurdraak.ini loaded successfully")
        print ("\00313" + "Anti spam speed is set to one command per " + str.strip(option["anti_spam_speed"]) + " seconds")

    except EnvironmentError:
        print ("\0034", "Could not open vuurdraak.ini  put it in your "+xchatdir+"")

def on_text(word, word_eol, userdata):
    destination = xchat.get_context()    
    trigger = re.split(' ',word[1].lower())
    vuurdraak[0] = round(time.time() ) - int(option["anti_spam_speed"])

    if vuurdraak[0] <= vuurdraak[1]:
        return xchat.EAT_NONE
    vuurdraak[1] = round(time.time() )

    try:
      if option[trigger[0]] != '':
          destination.command("say " + option[trigger[0]])

    except:
      if trigger[0] == '!calc':
          calculate(string.join(trigger[1:]), destination)

    return xchat.EAT_NONE

  
def calculate(expression, destination):
    try:
      if not invalid.search(expression):
        expression2 = re.sub('[A-Za-z]', '', expression)
        answer = eval(expression2)
        destination.command("say " + expression + " =" +
          " " + str(answer))
    
    except:
        return xchat.EAT_NONE


    return xchat.EAT_NONE
   
    
load_vars()

#The hooks go here
xchat.hook_print('Channel Message', on_text)

#LICENSE GPL
#Last modified 8-25-06 by Cancel
#Last modified 3-09-16 by Vuurdraak
#This was my first Python script, I based Vuurdraak Bot on Cancel's CalcBot and preserved it's !calc functionality.
